<?php
#	SonicCampGuard
#
#	Copyright (c) 2024 Bundeswehr
#	Diese Anwendung wurde von Cedric Prietz entwickelt.
#	E-Mail: CedricPrietz@bundeswehr.org
#	App: 90-8303-54618
#
#	Letzte Änderung: 23.01.2025

require_once $_SERVER['DOCUMENT_ROOT'] . '/function.inc.php';
pageName('Schutzbauten');
requireLogin();
requireRole(['Administrator']);
showSessionAlert();

initializeDatabaseConnection();

include($_SERVER['DOCUMENT_ROOT'] . '/header.inc.php');
?>

<div class="d-flex justify-content-between align-items-center flex-wrap grid-margin">
    <div>
        <h4 class="mb-md-0">Schutzbauten</h4>
        <span class="text-secondary">Administration</span>
    </div>
    <div class="d-flex align-items-center flex-wrap text-nowrap">

        <a href="/administration/add-shelter" class="btn btn-primary btn-icon-text">
            <i class="btn-icon-prepend mdi mdi-plus"></i> Hinzufügen
        </a>

    </div>
</div>

<div class="row">
    <div class="col-12 col-md-9 order-2 order-xl-1 grid-margin">
        <div class="card">
            <div class="card-header bg-primary text-white">
                Schutzbauten
            </div>
            <div class="card-body">
                <?php
                try {
                    $sql = "SELECT * FROM 
                                    Shelters
                                ORDER BY 
                                    Name
                            ";

                    $stmt = $pdo->prepare($sql);
                    $stmt->execute();
                    $results = $stmt->fetchAll(PDO::FETCH_ASSOC);

                    if ($results) {
                        echo '<div class="table-responsive">';
                        echo "<table id='dTableAdminZones' class='table table-bordered'>";
                        echo '<thead>
                                <tr>
                                    <th>Bezeichnung</th>
                                    <th width="15%">Telefon</th>
                                    <th width="15%">Funk</th>
                                    <th style="white-space: nowrap; width: 1%;">Optionen</th>
                                </tr>
                            </thead>';

                        foreach ($results as $row) {
                            echo "<tr>";
                            echo "<td class='fw-bold'>{$row['Name']}</td>";
                            echo "<td>{$row['Phone']}</td>";
                            echo "<td>{$row['Radio']}</td>";
                            echo '<td style="padding: .60rem .85rem;"><a href="/administration/edit-shelter?id=' . $row['ID'] . '" class="btn btn-sm btn-inverse-light btn-icon-text" style="margin: 0px;"><i class="mdi mdi-text-box-edit"></i> Bearbeiten</a></td>';
                            echo "</tr>";
                        }

                        echo "</table>";
                        echo '</div>';
                    } else {
                        echo '<div class="alert alert-warning mb-0" role="alert">
                                <i class="mdi mdi-alert-box-outline"></i>
                                Es sind noch keine Schutzbauten vorhanden.
                            </div>
                            ';
                    }
                } catch (PDOException $e) {
                    echo "Datenbankfehler: " . $e->getMessage();
                }
                ?>
            </div>
        </div>
    </div>

    <div class="col-12 col-md-3 order-1 order-xl-2 grid-margin">
        <div class="card">
            <div class="card-header bg-warning text-white">
                Information
            </div>
            <ul class="list-group list-group-flush">
                <li class="list-group-item">Hier können Sie <strong>Schutzbauten</strong> hinzufügen und
                    <strong>bearbeiten</strong>. Diese werden in einer <strong>interaktiven Karte</strong> dargestellt
                    und können im <strong>Alarmfall</strong> zur <strong>Auswertung</strong> in den Berichten für die
                    <strong>Zuordnung von Personen zu Schutzbauten</strong> genutzt werden.
                </li>
            </ul>
        </div>
    </div>

    <div class="col-12 col-md-12 order-1 order-xl-2 grid-margin">
        <div class="card">
            <div class="card-header bg-primary text-white">
                Karte
            </div>
            <div id="map" style="height: 600px;"></div>
        </div>
    </div>

</div>

<?php include($_SERVER['DOCUMENT_ROOT'] . '/footer.inc.php'); ?>

<script>
    var map = L.map('map').setView([<?php echo $app_config['map_position']; ?>], 15);
    L.tileLayer('<?php echo $app_config['map_tile']; ?>', {
        attribution: ''
    }).addTo(map);

    <?php
    $sql = "SELECT * 
            FROM Shelters
            WHERE Coordinates IS NOT NULL AND Coordinates != ''
            ORDER BY ID ASC;
            ";

    $stmt = $pdo->prepare($sql);
    $stmt->execute();
    $results = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if ($results) {
        foreach ($results as $row) {
            echo "var marker = L.marker([{$row['Coordinates']}], {icon: shelterIcon}).addTo(map);";
            echo "marker.bindPopup('Schutzbau<br><span class=\'text-warning\' style=\'font-size: 18px; font-weight: 600;\'>{$row['Name']}</span><br><br>Telefon: {$row['Phone']}<br>Funk: {$row['Radio']}');";
        }
    }
    ?>
</script>